dnl simulink.m4 --- check for Simulink.
dnl
dnl Copyright (C) 2000--2003 Ralph Schleicher
dnl
dnl This program is free software; you can redistribute it and/or
dnl modify it under the terms of the GNU General Public License as
dnl published by the Free Software Foundation; either version 2,
dnl or (at your option) any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; see the file COPYING.  If not, write to
dnl the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
dnl Boston, MA 02111-1307, USA.
dnl
dnl As a special exception to the GNU General Public License, if
dnl you distribute this file as part of a program that contains a
dnl configuration script generated by GNU Autoconf, you may include
dnl it under the same distribution terms that you use for the rest
dnl of that program.
dnl
dnl Code:

# AX_SIMULINK
# -----------
# Check for Simulink.
AC_DEFUN([AX_SIMULINK],
[dnl
AC_PREREQ([2.50])
AC_REQUIRE([AX_MATLAB])

ax_enable_simulink=
	AC_ARG_WITH([simulink], AC_HELP_STRING([--with-simulink], [check for Simulink [[yes]]]),
	[case $withval in
	  yes | no)
	    # Explicitly enable or disable Simulink.
	    ax_enable_simulink=$withval
	    ;;
	  *)
	    AC_MSG_ERROR([invalid value '$withval' for --with-simulink])
	    ;;
	esac])
	
if test x$ax_enable_simulink == xno ; then
	AC_MSG_CHECKING([whether to enable simulink support])
	AC_MSG_RESULT([$ax_enable_simulink])
else
	AC_MSG_CHECKING([whether to enable Simulink support])
	if test x$ax_enable_matlab = xno ; then
	    ax_enable_simulink=no
	fi
	if test x$ax_enable_simulink != xno ; then
	    if test -d "$MATLAB/simulink/include" ; then
		ax_enable_simulink=yes
	    elif test x$ax_enable_simulink = x ; then
		ax_enable_simulink=no
	    else
		# Fail if Simulink was explicitly enabled.
		AC_MSG_RESULT([failure])
		AC_MSG_ERROR([check your Matlab setup])
	    fi
	fi
	AC_MSG_RESULT([$ax_enable_simulink])
	if test x$ax_enable_simulink = xyes ; then
		ax_simulink_path=$ax_cv_matlab
	    AC_DEFINE([HAVE_SIMULINK], [1], [Define if you have Simulink.])
	fi
fi
AC_SUBST(SIMULINK,$ax_simulink_path)
])

# AX_REQUIRE_SIMULINK
# -------------------
# Like AX_SIMULINK but fail if Simulink support is disabled.
AC_DEFUN([AX_REQUIRE_SIMULINK],
[dnl
AC_PREREQ([2.50])
AC_REQUIRE([AX_SIMULINK])
if test x$ax_enable_simulink = xno ; then
    AC_MSG_ERROR([can not enable Simulink support])
fi
])

# AX_SIMULINK_CONDITIONAL
# -----------------------
# Define Simulink conditional for GNU Automake.
AC_DEFUN([AX_SIMULINK_CONDITIONAL],
[dnl
AC_PREREQ([2.50])
AC_REQUIRE([AX_SIMULINK])
AM_CONDITIONAL([SIMULINK], [test x$ax_enable_simulink = xyes])
])

dnl simulink.m4 ends here
